'MMEDIT!!! Basic Version = Micromite_5.05.01
'MMEDIT!!! Port = COM18:38400:10,300
'MMEDIT!!! Device = Micromite_5.05.01
  'Micromite controls for Digital Preamp with Tone Controls
  ''MM V2 Backpack connected to Digital preamp board
  ''pins:
  ''4:LED
  ''5:IC2CS (IC6)?
  ''9:IC5CS (IC7)?
  ''10:digipot SHDN
  ''16:IR
  ''17:RLY1
  ''18:RLY2
  ''21:RLY3
  ''22:RLY4
  ''24:digipot RS
  ''LED and relays are active low
  ''digipots also attach to hardware SPI instance on 3/14/25
  
  'LCD settings for 2.8in (can replace LANDSCAPE with RLANDSCAPE if inverted)
  'OPTION LCDPANEL ILI9341, LANDSCAPE, 2, 23, 6
  'OPTION TOUCH 7, 15
  'GUI CALIBRATE 0, 143, 293, 893, 685
  
  'LCD settings for 3.5in (edit ILI9488 Library.bas to change rotation)
  'load ILI9488 Library.bas and enter:
  'LIBRARY SAVE
  'CPU RESTART
  'OPTION TOUCH 7, 15
  'GUI CALIBRATE 0, 3891, 3851, -1277, -860
  
  OPTION EXPLICIT
  OPTIOn BASE 0
  OPTION AUTORUN ON
  
  'dynamic scaling
  'aliases for TEXT,BOX,LINE and DRAWBUTTON (etc)
  'TEXTS, BOXS, LINES assume a resoultion of 80x80 and scale to suit
  'DRAWBUTTON modified and stores/works with native numbers after conversion
  DIM INTEGER SX,SY 'screen step sizes, there are 80x80 steps on the screen
  'defaults for 320x240
  SX=4
  SY=3
  IF MM.HRES > 320 THEN SX=MM.HRES\80
  IF MM.VRES > 240 THEN SY=MM.VRES\80
  'TEXT position aliases (use TEXTS call), scale 1 under TEXTS= 40 ch/line (ie same as scale 1 on 320 wide)
  CONST LT = 1
  CONST CT = 2
  CONST RT = 3
  CONST LM = 4
  CONST CM = 5
  CONST RM = 6
  CONST LB = 7
  CONST CB = 8
  CONST RB = 9
  
  CONST BUTTON_COUNT=45 'only need this many for the keyboard
  CONST SAVE_BUTTON=BUTTON_COUNT-1
  DIM B_COORD(BUTTON_COUNT,4) AS INTEGER  'x,y,w,h
  DIM BUTTON_TEXT(BUTTON_COUNT) AS STRING LENGTH 30
  DIM INTEGER BUTTON_COL         ' for colour changes
  CONST C.BUTTON=RGB(cyan)       ' button colour default
  Const C.B=RGB(BLACK)           ' background colour
  Const C.F=RGB(WHITE)           ' border colour
  CONST C.SAVEDONE=RGB(GRAY)
  CONST C.SAVENEEDED=RGB(RED)
  CONST C.GRAPH=RGB(GREEN)
  CONST C.LOGO=RGB(255,192,0)
  BUTTON_COL=C.BUTTON
  CONST SPLASHDELAY=1500
  CONST LEDDELAY=300
  CONST AUTOREPEAT = 50
  CONST AUTODELAY = 150
  
  CONST LED_PIN = 4
  CONST RLY1_PIN = 17
  CONST RLY2_PIN = 18
  CONST RLY3_PIN = 21
  CONST RLY4_PIN = 22
  CONST DP1_PIN = 5
  CONST DP2_PIN = 9
  CONST DPRS_PIN = 24
  CONST DPSH_PIN = 10
  'digipot channels
  CONST DP_PRE_CH = 1
  CONST DP_BASS_CH = 3
  CONST DP_MID_CH = 0
  CONST DP_TREB_CH = 2
  
  CONST FREQCOUNT=10
  CONST DBMIN=-20
  CONST DBMAX=20
  DIM INTEGER X,Y,I,C
  DIM INTEGER MASTERVOL, MUTE, PRESET, INLEVEL, BASSLEVEL, MIDLEVEL, TREBLELEVEL, AUDIOIN, LOUDNESS
  DIM INTEGER MASTERVOLOLD, MUTEOLD, PRESETOLD, INLEVELOLD, BASSLEVELOLD, MIDLEVELOLD, TREBLELEVELOLD, AUDIOINOLD, LOUDNESSOLD, MUTEOLDDISP
  DIM INTEGER BL_NORMAL,BL_IDLE,BL_TIMEOUT,SAVE_TIMEOUT,BLCURRENT
  BLCURRENT=0         'to check for changes and avoid repeated changes
  BL_NORMAL=100
  BL_IDLE=100
  BL_TIMEOUT=30*1000  'in millis
  SAVE_TIMEOUT=10*60*1000 'in millis
  CONST PRESETCOUNT = 6
  DIM INTEGER PRESETS(PRESETCOUNT,6)' all items after preset above
  DIM STRING PRESETNAMES(PRESETCOUNT) LENGTH 30
  FOR I = 0 TO PRESETCOUNT-1
    PRESETS(I,0)=0'midrange input
    PRESETS(I,1)=0'midrange bass
    PRESETS(I,2)=0'midrange mid
    PRESETS(I,3)=0'midrange treble
    PRESETS(I,4)=(I MOD 4)+1'input#
    PRESETS(I,5)=0'bypass => use EQ
    PRESETNAMES(I)="PRESET "+STR$(I+1)
  NEXT I
  'for IR EQ buttons
  CONST IR_BASS = 7
  CONST IR_MID = 8
  CONST IR_TREB = 9
  CONST IR_LOUD = 10
  INITDATA
  INITIO
  MASTERVOL=0
  MUTE=0
  PRESET=0
  INLEVEL=PRESETS(0,0)
  BASSLEVEL=PRESETS(0,1)
  MIDLEVEL=PRESETS(0,2)
  TREBLELEVEL=PRESETS(0,3)
  AUDIOIN=PRESETS(0,4)
  'EQBYPASS=PRESETS(0,5)
  LOUDNESS=PRESETS(0,5) ''use this slot for loudness
  VAR RESTORE
  VAR SAVE MASTERVOL, MUTE, PRESET, INLEVEL, BASSLEVEL, MIDLEVEL, TREBLELEVEL, AUDIOIN, LOUDNESS
  VAR SAVE BL_NORMAL,BL_IDLE,BL_TIMEOUT,SAVE_TIMEOUT,PRESETS(),PRESETNAMES()
  SETBACKLIGHT(BL_NORMAL)
  LASTBACKLIGHT=TIMER  'reset backlight timer
  ''actions
  CONST PREUP = 2
  CONST PREDOWN = 3
  CONST BASSUP = 4
  CONST BASSDOWN = 5
  CONST MIDUP = 6
  CONST MIDDOWN = 7
  CONST TREBUP = 8
  CONST TREBDOWN = 9
  UPDATEHARDWARE(1) 'force update
  DRAWBUTTON(SAVE_BUTTON,0,64,0,15, 9,"SAVE")  'this just sets up button for later auto redraw
  DRAWMAIN
  'main loop here
  DO
    IF TOUCH(X)>-1 THEN LASTBACKLIGHT=TIMER  'reset backlight timer on any touch
    C=CHECKBUTTON(0,10)
    IF C>-1 THEN
      LASTBACKLIGHT=TIMER  'reset backlight timer
      SETBACKLIGHT(BL_NORMAL)
      IF C = 0 THEN CHECKRELEASE(C): LOADPRESET(0)
      IF C = 1 THEN CHECKRELEASE(C): LOADPRESET(1)
      IF C = 2 THEN CHECKRELEASE(C): LOADPRESET(2)
      IF C = 3 THEN CHANGEVOLUMEUP
      IF C = 4 THEN CHECKRELEASE(C): LOADPRESET(3)
      IF C = 5 THEN CHECKRELEASE(C): LOADPRESET(4)
      IF C = 6 THEN CHECKRELEASE(C): LOADPRESET(5)
      IF C = 7 THEN CHECKRELEASE(C): SETPAGE: C=-1:LASTBACKLIGHT=TIMER:DRAWMAIN
      IF C = 8 THEN CHECKRELEASE(C): EQPAGE: C=-1:LASTBACKLIGHT=TIMER:DRAWMAIN
      IF C = 9 THEN
        TOGGLEMUTE
        DRAWBUTTON(9,MUTE+1)
        DO WHILE ISBUTTONPRESSED(9)>0 'wait until release
          IDLE(10)
        LOOP
        DRAWBUTTON(9,MUTE+1)
      ENDIF
      IF C = 10 THEN CHANGEVOLUMEDOWN
    ENDIF
    UPDATEMAIN
    IF (SPLASHTIMEOUT>TIMER) AND (SPLASHNEEDED>0) THEN
      SPLASHNEEDED=0
      DOSPLASH(SPLASHA,SPLASHB,0)
      DO WHILE(SPLASHTIMEOUT>TIMER)
        IF (SPLASHNEEDED>0) THEN    'if we get repeated IR hits
          SPLASHNEEDED=0
          DOSPLASH(SPLASHA,SPLASHB,1)
        ENDIF
        IDLE(20)
      LOOP
      DRAWMAIN
    ENDIF
    CHECKBACKLIGHT
    IDLE(20)
    IF USESLEEP > 0 THEN  'none of these work adequately enough
      'IR CLOSE: CPU SLEEP 1,16: IR IRDEVICE,IRCODE,IR_INT
      'CPU SLEEP 'use builtin wakeup pin on IR
    ENDIF
  LOOP
  
SUB UPDATEMAIN  'redrawable parts
  IF MUTEOLDDISP <> MUTE THEN
    DRAWBUTTON(9,MUTE+1)
    MUTEOLDDISP = MUTE
  ENDIF
  IF PRESETOLD <> PRESET THEN
    IF PRESET=0 THEN DRAWBUTTON(0,2) ELSE DRAWBUTTON(0,1)
    IF PRESET=1 THEN DRAWBUTTON(1,2) ELSE DRAWBUTTON(1,1)
    IF PRESET=2 THEN DRAWBUTTON(2,2) ELSE DRAWBUTTON(2,1)
    IF PRESET=3 THEN DRAWBUTTON(4,2) ELSE DRAWBUTTON(4,1)
    IF PRESET=4 THEN DRAWBUTTON(5,2) ELSE DRAWBUTTON(5,1)
    IF PRESET=5 THEN DRAWBUTTON(6,2) ELSE DRAWBUTTON(6,1)
    PRESETOLD=PRESET  'screen has been updated
  ENDIF
  SHOWMAINVOL 'this can be redrawn without flicker
END SUB
  
SUB CHECKBACKLIGHT
  LOCAL INTEGER S
  S=BL_TIMEOUT-TIMER+LASTBACKLIGHT
  IF S<0 THEN
    S=0
    SETBACKLIGHT(BL_IDLE)
    USESLEEP=1
  ELSE
    SETBACKLIGHT(BL_NORMAL)
    USESLEEP=0
  ENDIF
  IF S>BL_TIMEOUT THEN
    S=BL_TIMEOUT
  ENDIF
  S=S\1000
  IF S>999 THEN S=999 ' for display
  TEXTS 79,13,STR$(S,3),RM,1,1,C.F,C.B
END SUB
  
SUB SETBACKLIGHT(B AS INTEGER)  '% as per Micromite
  IF B <> BLCURRENT THEN
    PWM 2,50000,B
    BLCURRENT=B
  ENDIF
END SUB
  
SUB DRAWMAIN
  CLS
  SETBACKLIGHT(BL_NORMAL)
  TEXTS 0,0," ",LT,10,1,C.LOGO,C.B   'this is the SC logo
  TEXTS 34,0,"DIGITAL",LT,1,2,C.F,C.B
  TEXTS 36,8,"PREAMP",LT,1,2,C.F,C.B
  DRAWBUTTON(0,0,0,17,19,20,PRESETNAMES(0))
  DRAWBUTTON(1,0,20,17,19,20,PRESETNAMES(1))
  DRAWBUTTON(2,0,40,17,19,20,PRESETNAMES(2))
  DRAWBUTTON(3,0,60,17,19,20,"VOL UP")
  DRAWBUTTON(4,0,0,38,19,20,PRESETNAMES(3))
  DRAWBUTTON(5,0,20,38,19,20,PRESETNAMES(4))
  DRAWBUTTON(6,0,40,38,19,20,PRESETNAMES(5))
  DRAWBUTTON(7,0,0,59,19,20,"PRESETS")
  DRAWBUTTON(8,0,20,59,19,20,"EQ SET")
  DRAWBUTTON(9,0,40,59,19,20,"MUTE")
  DRAWBUTTON(9,MUTE+1)  'redraw state
  DRAWBUTTON(10,0,60,59,19,20,"VOL DOWN")
  IF PRESET=0 THEN DRAWBUTTON(0,2)
  IF PRESET=1 THEN DRAWBUTTON(1,2)
  IF PRESET=2 THEN DRAWBUTTON(2,2)
  IF PRESET=3 THEN DRAWBUTTON(4,2)
  IF PRESET=4 THEN DRAWBUTTON(5,2)
  IF PRESET=5 THEN DRAWBUTTON(6,2)
  PRESETOLD=PRESET  'screen has been updated
  MUTEOLDDISP=MUTE  'for display and not hardware
  DRAWSAVEBUTTON
END SUB
  
SUB TOGGLEMUTE
  MUTE=1-MUTE
  UPDATEHARDWARE(1) 'force fade
  SAVENEEDED=1
END SUB
  
SUB SETPAGE
  LOCAL INTEGER R
  LOCAL STRING NM
  DRAWSETPAGE
  DO
    C=CHECKBUTTON(0,16)
    IF C>-1 THEN
      IF C>=0 AND C<=5 THEN 'save to preset #
        R=C
        CHECKRELEASE(C)
        IF CONFIRM_CHECK("SAVE CURRENT EQ","SET TO "+PRESETNAMES(R)+"?") > 0 THEN
          PRESETS(R,0)=INLEVEL
          PRESETS(R,1)=BASSLEVEL
          PRESETS(R,2)=MIDLEVEL
          PRESETS(R,3)=TREBLELEVEL
          PRESETS(R,4)=AUDIOIN
          PRESETS(R,5)=LOUDNESS
          TOASTBANNER("STORED TO PRESET",PRESETNAMES(R))
          SAVENEEDED=1
        ENDIF
        DRAWSETPAGE
      ENDIF
      IF C>=6 AND C<=11 THEN 'change preset # name
        CHECKRELEASE(C)
        NM=GET_KEY_PAD("PRESET "+RIGHT$(STR$(C-5),1)+" NAME:")
        IF LEN(NM)>0 THEN
          PRESETNAMES(C-6)=NM
          SAVENEEDED=1
          TOASTBANNER("NAME CHANGED TO",PRESETNAMES(C-6))
        ENDIF
        DRAWSETPAGE
      ENDIF
      IF C = 12 THEN CHECKRELEASE(C): C=-1: EXIT SUB
      IF C = 13 THEN
        R=GET_NUMBER_PAD("BACKLIGHT HI 1-100%")
        IF R>=1 AND R<=100 THEN
          BL_NORMAL=R
          SETBACKLIGHT(BL_NORMAL)
          SAVENEEDED=1
          TOASTBANNER("SET TO",STR$(BL_NORMAL)+"%")
        ELSE IF R<0 THEN
          ''do nothing on cancel
        ELSE
          TOASTBANNER("VALUE OUT","OF RANGE")
        ENDIF
        DRAWSETPAGE
      ENDIF
      IF C = 14 THEN
        R=GET_NUMBER_PAD("BACKLIGHT LO 0-100%")
        IF R>=0 AND R<=100 THEN
          BL_IDLE=R
          SAVENEEDED=1
          TOASTBANNER("SET TO",STR$(BL_IDLE)+"%")
        ELSE IF R<0 THEN
          ''do nothing on cancel
        ELSE
          TOASTBANNER("VALUE OUT","OF RANGE")
        ENDIF
        DRAWSETPAGE
      ENDIF
      IF C = 15 THEN
        R=GET_NUMBER_PAD("B/L TIMEOUT 1-999s")
        IF R>=1 AND R<1000 THEN
          BL_TIMEOUT=R*1000 'convert to seconds
          SAVENEEDED=1
          TOASTBANNER("SET TO",STR$(BL_TIMEOUT\1000)+"s")
        ELSE IF R<0 THEN
          ''do nothing on cancel
        ELSE
          TOASTBANNER("VALUE OUT","OF RANGE")
        ENDIF
        DRAWSETPAGE
      ENDIF
      IF C = 16 THEN
        R=GET_NUMBER_PAD("SAVE TIMEOUT 1-999m")
        IF R>=1 AND R<1000 THEN
          SAVE_TIMEOUT=R*60000 'convert to minutes
          SAVENEEDED=1
          TOASTBANNER("SET TO",STR$(SAVE_TIMEOUT\60000)+"m")
        ELSE IF R<0 THEN
          ''do nothing on cancel
        ELSE
          TOASTBANNER("VALUE OUT","OF RANGE")
        ENDIF
        DRAWSETPAGE
      ENDIF
    ENDIF
    IDLE(20)
  LOOP
END SUB
  
SUB DRAWSETPAGE
  CLS
  TEXTS 0,0,"SETTINGS",LT,1,2,C.F,C.B
  DRAWBUTTON( 0,0, 0, 11,19,10,PRESETNAMES(0))
  DRAWBUTTON( 1,0, 0, 22,19,10,PRESETNAMES(1))
  DRAWBUTTON( 2,0, 0, 33,19,10,PRESETNAMES(2))
  DRAWBUTTON( 3,0, 0, 44,19,10,PRESETNAMES(3))
  DRAWBUTTON( 4,0, 0, 55,19,10,PRESETNAMES(4))
  DRAWBUTTON( 5,0, 0, 66,19,10,PRESETNAMES(5))
  DRAWBUTTON( 6,0,20, 11,14,10,"RENAME")
  DRAWBUTTON( 7,0,20, 22,14,10,"RENAME")
  DRAWBUTTON( 8,0,20, 33,14,10,"RENAME")
  DRAWBUTTON( 9,0,20, 44,14,10,"RENAME")
  DRAWBUTTON(10,0,20, 55,14,10,"RENAME")
  DRAWBUTTON(11,0,20, 66,14,10,"RENAME")
  DRAWBUTTON(12,0,48,  0,15, 9,"BACK")
  DRAWBUTTON(13,0,64, 14,15, 9,"B/L HI")
  DRAWBUTTON(14,0,64, 30,15, 9,"B/L LO")
  DRAWBUTTON(15,0,64, 46,15, 9,"B/L TM")
  DRAWBUTTON(16,0,64, 62,15, 9,"SAVE T")
  DRAWPRESET(     36, 11,0)
  DRAWPRESET(     36, 22,1)
  DRAWPRESET(     36, 33,2)
  DRAWPRESET(     36, 44,3)
  DRAWPRESET(     36, 55,4)
  DRAWPRESET(     36, 66,5)
  DRAWSAVEBUTTON
  TEXTS 72, 24,RIGHT$(STR$(BL_NORMAL),3)+"%",CT,1,1,C.F,C.B
  TEXTS 72, 40,RIGHT$(STR$(BL_IDLE),3)+"%",CT,1,1,C.F,C.B
  TEXTS 72, 56,RIGHT$(STR$(BL_TIMEOUT\1000),3)+"s",CT,1,1,C.F,C.B
  TEXTS 72, 72,RIGHT$(STR$(SAVE_TIMEOUT\60000),3)+"m",CT,1,1,C.F,C.B
END SUB
  
SUB DRAWPRESET(X AS INTEGER, Y AS INTEGER,P AS INTEGER) 'draw text outline of preset settings
  TEXTS X,Y,"IN"+LEFT$(STR$(PRESETS(P,4),1),1)+" PRE:"+RIGHT$(STR$(PRESETS(P,0),3),3),LT,1,1,C.F,C.B
  IF PRESETS(P,5)> 0 THEN
    TEXTS X+ 0,Y+4,"BYPASS ON    ",LT,1,1,C.F,C.B
  ELSE
    TEXTS X+ 0,Y+4,"B"+RIGHT$(STR$(PRESETS(P,1),3),3),LT,1,1,C.F,C.B
    TEXTS X+ 9,Y+4,"M"+RIGHT$(STR$(PRESETS(P,2),3),3),LT,1,1,C.F,C.B
    TEXTS X+18,Y+4,"T"+RIGHT$(STR$(PRESETS(P,3),3),3),LT,1,1,C.F,C.B
  ENDIF
END SUB
  
SUB EQPAGE
  DRAWEQPAGE
  DO
    C=CHECKBUTTON(0,15)
    IF C>-1 THEN
      IF C = 0 THEN HOLDBUTTON(C,PREUP):PRESET=-1
      IF C = 1 THEN HOLDBUTTON(C,BASSUP):PRESET=-1
      IF C = 2 THEN HOLDBUTTON(C,MIDUP):PRESET=-1
      IF C = 3 THEN HOLDBUTTON(C,TREBUP):PRESET=-1
      IF C = 5 THEN HOLDBUTTON(C,PREDOWN):PRESET=-1
      IF C = 6 THEN HOLDBUTTON(C,BASSDOWN):PRESET=-1
      IF C = 7 THEN HOLDBUTTON(C,MIDDOWN):PRESET=-1
      IF C = 8 THEN HOLDBUTTON(C,TREBDOWN):PRESET=-1
      IF C = 9 THEN
        CHECKRELEASE(C)
        INLEVEL=0
        BASSLEVEL=0
        MIDLEVEL=0
        TREBLELEVEL=0
        UPDATEHARDWARE(1) 'update with forced fade
        SAVENEEDED=1
        DRAWEQVALS
      ENDIF
      IF C = 10 THEN CHECKRELEASE(C): AUDIOIN=1:DRAWEQVALS:PRESET=-1:SAVENEEDED=1
      IF C = 11 THEN CHECKRELEASE(C): AUDIOIN=2:DRAWEQVALS:PRESET=-1:SAVENEEDED=1
      IF C = 12 THEN CHECKRELEASE(C): AUDIOIN=3:DRAWEQVALS:PRESET=-1:SAVENEEDED=1
      IF C = 13 THEN CHECKRELEASE(C): AUDIOIN=4:DRAWEQVALS:PRESET=-1:SAVENEEDED=1
      IF C = 14 THEN CHECKRELEASE(C): SETPAGE:C=-1:DRAWEQPAGE
      IF C = 15 THEN CHECKRELEASE(C): C=-1: EXIT SUB
      ''new buttons
      IF C = 4 THEN
        CHECKRELEASE(C)
        LOUDNESS = LOUDNESS + 1
        IF LOUDNESS > 4 THEN LOUDNESS = 4
        DRAWEQVALS
        PRESET=-1
        SAVENEEDED=1
      endif
      IF C = 16 THEN
        CHECKRELEASE(C)
        LOUDNESS = LOUDNESS - 1
        IF LOUDNESS < 0 THEN LOUDNESS = 0
        DRAWEQVALS
        PRESET=-1
        SAVENEEDED=1
      endif
    ENDIF
    IDLE(20)
    IF IRCHANGE > 0 THEN DRAWEQVALS:IRCHANGE=0'force redraw on IR change
  LOOP
END SUB
  
SUB HOLDBUTTON(N AS INTEGER,A AS INTEGER) 'implement repeated action(A) on holding a button(N) down
  LOCAL INTEGER T0
  T0=TIMER+AUTODELAY
  DRAWBUTTON(N,2)'button down
  ACTION(A)
  DO WHILE ISBUTTONPRESSED(N)>0
    IDLE(1)
    IF (TIMER-T0)> AUTOREPEAT THEN
      T0=T0+AUTOREPEAT
      ACTION(A)
    ENDIF
  LOOP
  DRAWBUTTON(N,1)'button normal
END SUB
  
SUB ACTION(A AS INTEGER)  'cos we don't have function pointers
  SAVENEEDED=1  'pretty much any action needs a save
  SELECT CASE A
    CASE PREDOWN
      INLEVEL=INLEVEL-1
      IF INLEVEL<-127 THEN INLEVEL=-127
      DRAWEQVALS
    CASE PREUP
      INLEVEL=INLEVEL+1
      IF INLEVEL>127 THEN INLEVEL=127
      DRAWEQVALS
    CASE BASSDOWN
      BASSLEVEL=BASSLEVEL-1
      IF BASSLEVEL<-127 THEN BASSLEVEL=-127
      DRAWEQVALS
    CASE BASSUP
      BASSLEVEL=BASSLEVEL+1
      IF BASSLEVEL>127 THEN BASSLEVEL=127
      DRAWEQVALS
    CASE MIDDOWN
      MIDLEVEL=MIDLEVEL-1
      IF MIDLEVEL<-127 THEN MIDLEVEL=-127
      DRAWEQVALS
    CASE MIDUP
      MIDLEVEL=MIDLEVEL+1
      IF MIDLEVEL>127 THEN MIDLEVEL=127
      DRAWEQVALS
    CASE TREBDOWN
      TREBLELEVEL=TREBLELEVEL-1
      IF TREBLELEVEL<-127 THEN TREBLELEVEL=-127
      DRAWEQVALS
    CASE TREBUP
      TREBLELEVEL=TREBLELEVEL+1
      IF TREBLELEVEL>127 THEN TREBLELEVEL=127
      DRAWEQVALS
  END SELECT
END SUB
  
SUB DRAWEQPAGE
  CLS
  LOCAL INTEGER I
  TEXTS 0,0,"EQ SET",LT,1,2,C.F,C.B
  DRAWBUTTON( 0,0,  0, 10,15, 9,"PRE +")
  DRAWBUTTON( 1,0, 16, 10,15, 9,"BASS +")
  DRAWBUTTON( 2,0, 32, 10,15, 9,"MID +")
  DRAWBUTTON( 3,0, 48, 10,15, 9,"TREB +")
  DRAWBUTTON( 5,0,  0, 31,15, 9,"PRE -")
  DRAWBUTTON( 6,0, 16, 31,15, 9,"BASS -")
  DRAWBUTTON( 7,0, 32, 31,15, 9,"MID -")
  DRAWBUTTON( 8,0, 48, 31,15, 9,"TREB -")
  DRAWBUTTON(10,0,  0, 41,15, 9,"INP 1")
  DRAWBUTTON(11,0, 16, 41,15, 9,"INP 2")
  DRAWBUTTON(12,0, 32, 41,15, 9,"INP 3")
  DRAWBUTTON(13,0, 48, 41,15, 9,"INP 4")
  DRAWBUTTON(14,0, 64, 41,15, 9,"STORE")
  DRAWBUTTON(15,0, 48,  0,15, 9,"BACK")
  ''altered buttons from earlier versions
  DRAWBUTTON( 9,0, 32,  0,15, 9,"RESET")
  DRAWBUTTON( 4,0, 64, 10,15, 9,"LOUD +")
  DRAWBUTTON(16,0, 64, 31,15, 9,"LOUD -")
  FOR I = 0 TO FREQCOUNT-1
    IF FREQ(I)> 999 THEN
      TEXTS I*7.5+11.5,76,STR$(INT(FREQ(I)/1000))+"k",RT,1,1,C.F,C.B
    ELSE
      TEXTS I*7.5+11.5,76,STR$(INT(FREQ(I))),RT,1,1,C.F,C.B
    ENDIF
  NEXT I
  TEXTS 10,51,"+20dB",RT,1,1,C.F,C.B
  TEXTS 10,63,"0dB",RM,1,1,C.F,C.B
  TEXTS 10,75,"-20dB",RB,1,1,C.F,C.B
  DRAWEQVALS
  DRAWSAVEBUTTON
END SUB
  
SUB DRAWEQVALS
  UPDATEHARDWARE(0)''output to hardware normally
  TEXTS  8,25,LEFT$(STR$(INLEVEL,4),4),CM,1,1,C.F,C.B
  IF IREQBAND=IR_BASS THEN
    TEXTS 24,25,LEFT$(STR$(BASSLEVEL,4),4),CM,1,1,C.B,C.F
  ELSE
    TEXTS 24,25,LEFT$(STR$(BASSLEVEL,4),4),CM,1,1,C.F,C.B
  ENDIF
  IF IREQBAND=IR_MID THEN
    TEXTS 40,25,LEFT$(STR$(MIDLEVEL,4),4),CM,1,1,C.B,C.F
  ELSE
    TEXTS 40,25,LEFT$(STR$(MIDLEVEL,4),4),CM,1,1,C.F,C.B
  ENDIF
  IF IREQBAND=IR_TREB THEN
    TEXTS 56,25,LEFT$(STR$(TREBLELEVEL,4),4),CM,1,1,C.B,C.F
  ELSE
    TEXTS 56,25,LEFT$(STR$(TREBLELEVEL,4),4),CM,1,1,C.F,C.B
  ENDIF
  IF IREQBAND=IR_LOUD THEN
    TEXTS 72,25,LEFT$(STR$(LOUDNESS,2),2)+" ",CM,1,1,C.B,C.F
  ELSE
    TEXTS 72,25,LEFT$(STR$(LOUDNESS,2),2)+" ",CM,1,1,C.F,C.B
  ENDIF
  IF AUDIOIN = 1 THEN DRAWBUTTON(10,2) ELSE DRAWBUTTON(10,1)
  IF AUDIOIN = 2 THEN DRAWBUTTON(11,2) ELSE DRAWBUTTON(11,1)
  IF AUDIOIN = 3 THEN DRAWBUTTON(12,2) ELSE DRAWBUTTON(12,1)
  IF AUDIOIN = 4 THEN DRAWBUTTON(13,2) ELSE DRAWBUTTON(13,1)
  DRAWGRAPHS
END SUB
  
SUB DRAWGRAPHS
  LOCAL INTEGER I
  LOCAL FLOAT X1,X2,Y1,Y2
  SETDBCURRENT(INLEVEL,BASSLEVEL,MIDLEVEL,TREBLELEVEL)
  FOR I = 0 TO FREQCOUNT-2
    X1=I*7.5+10.75
    X2=X1+7.5
    Y1=63-DBOLD(I)*0.6
    Y2=63-DBOLD(I+1)*0.6
    IF Y1<51 THEN Y1=51
    IF Y1>75 THEN Y1=75
    IF Y2<51 THEN Y2=51
    IF Y2>75 THEN Y2=75
    LINES X1,Y1,X2,Y2,1,C.B 'erase old
    LINES X1,51,X1,75,1,C.F 'new verticals
  NEXT I
  LINES X2,51,X2,75,1,C.F   'last new vertical
  LINES 10.75,63,78.25,63,1,C.F 'centre
  LINES 10.75,51,78.25,51,1,C.F 'top
  LINES 10.75,75,78.25,75,1,C.F 'bottom
  FOR I = 0 TO FREQCOUNT-2
    X1=I*7.5+10.75
    X2=X1+7.5
    Y1=63-DBCURRENT(I)*0.6
    Y2=63-DBCURRENT(I+1)*0.6
    IF Y1<51 THEN Y1=51
    IF Y1>75 THEN Y1=75
    IF Y2<51 THEN Y2=51
    IF Y2>75 THEN Y2=75
    LINES X1,Y1,X2,Y2,1,C.GRAPH
  NEXT I
  FOR I = 0 TO FREQCOUNT-1
    DBOLD(I)=DBCURRENT(I)
  NEXT I
END SUB
  
SUB SHOWMAINVOL
  TEXTS 70,47,STR$(MASTERVOL,3),CM,1,3,C.F,C.B
END SUB
  
SUB CHANGEVOLUMEUP  'implements hold and scroll
  LOCAL INTEGER T0
  T0=TIMER+AUTODELAY
  DRAWBUTTON(3,2)'button down
  CHANGEVOL(1)
  SHOWMAINVOL
  DO WHILE ISBUTTONPRESSED(3)>0
    IDLE(1)
    IF (TIMER-T0)> AUTOREPEAT THEN
      T0=T0+AUTOREPEAT
      CHANGEVOL(1)
      SHOWMAINVOL
    ENDIF
  LOOP
  DRAWBUTTON(3,1)'button normal
END SUB
  
SUB CHANGEVOLUMEDOWN  'implements hold and scroll
  LOCAL INTEGER T0
  T0=TIMER+AUTODELAY
  DRAWBUTTON(10,2)'button down
  CHANGEVOL(-1)
  SHOWMAINVOL
  DO WHILE ISBUTTONPRESSED(10)>0
    IDLE(1)
    IF (TIMER-T0)> AUTOREPEAT THEN
      T0=T0+AUTOREPEAT
      CHANGEVOL(-1)
      SHOWMAINVOL
    ENDIF
  LOOP
  DRAWBUTTON(10,1)'button normal
END SUB
  
SUB CHANGEVOL(N AS INTEGER)
  MASTERVOL=MASTERVOL+N
  IF MASTERVOL>99 THEN MASTERVOL=99
  IF MASTERVOL<-99 THEN MASTERVOL=-99
  UPDATEHARDWARE(0)''output to hardware normally
  IF N<>0 THEN SAVENEEDED=1
END SUB
  
SUB LOADPRESET(N AS INTEGER)
  PRESETOLD=-1  'force redraw even if same preset selected
  PRESET=N
  INLEVEL=PRESETS(N,0)
  BASSLEVEL=PRESETS(N,1)
  MIDLEVEL=PRESETS(N,2)
  TREBLELEVEL=PRESETS(N,3)
  AUDIOIN=PRESETS(N,4)
  LOUDNESS=PRESETS(N,5)
  UPDATEHARDWARE(1) 'force fade
  SAVENEEDED=1
END SUB
  
SUB UPDATEHARDWARE(F AS INTEGER)    ''call this to push changes out
  'set up initial states MASTERVOLOLD, MUTEOLD, PRESETOLD, INLEVELOLD, BASSLEVELOLD, MIDLEVELOLD, TREBLELEVELOLD, AUDIOINOLD, LOUDNESSOLD
  LOCAL INTEGER FADENEEDED,LEVELOLD,LEVEL,I
  LOCAL INTEGER BASSOUT, MIDOUT, TREBOUT  'value for digipots
  IF MASTERVOL<0 THEN 'loudness adjustment needed
    BASSOUT = 128-(BASSLEVEL - (MASTERVOL * LOUDNESS)\16) ''assumes loudness = 0-4, 1dB/4dB
    MIDOUT = 128-MIDLEVEL
    TREBOUT = 128-(TREBLELEVEL - (MASTERVOL * LOUDNESS)\32) ''assumes loudness = 0-4, 0.5dB/4dB
  ELSE    ''no adjustment needed
    BASSOUT = 128-BASSLEVEL
    MIDOUT = 128-MIDLEVEL
    TREBOUT = 128-TREBLELEVEL
  ENDIF
  'clamp adjusted values
  IF BASSOUT<0 THEN BASSOUT=0
  IF MIDOUT<0 THEN MIDOUT=0
  IF TREBOUT<0 THEN TREBOUT=0
  IF BASSOUT>255 THEN BASSOUT=255
  IF MIDOUT>255 THEN MIDOUT=255
  IF TREBOUT>255 THEN TREBOUT=255
  'check levels and fade requirements
  FADENEEDED=0
  LEVEL=0
  LEVELOLD=0
  IF MUTE=0 THEN LEVEL=MASTERVOL+INLEVEL+128
  IF LEVEL>255 THEN LEVEL=255
  IF LEVEL<  0 THEN LEVEL=  0
  IF MUTEOLD=0 THEN LEVELOLD=MASTERVOLOLD+INLEVELOLD+128
  IF LEVELOLD>255 THEN LEVELOLD=255
  IF LEVELOLD<  0 THEN LEVELOLD=  0
  IF AUDIOINOLD <> AUDIOIN THEN FADENEEDED=1  'if input select has changed
  'IF EQBYPASSOLD <> EQBYPASS THEN FADENEEDED=1  'if bypass select has changed
  IF MUTE <> MUTEOLD THEN FADENEEDED=1
  IF F>0 THEN FADENEEDED=1  'forced
  IF FADENEEDED>0 THEN
    'PRINT "FADING OUT"
    FOR I = LEVELOLD - (LEVELOLD MOD 10) TO 0 STEP -10
      DIGIPOT(DP_PRE_CH,I)
      'PRINT I
      'PAUSE 0.1
    NEXT I
  ENDIF
  'PRINT "SETTING"
  'RLY4(EQBYPASS)
  SETINPUT(AUDIOIN)
  DIGIPOT(DP_BASS_CH,BASSOUT)
  DIGIPOT(DP_MID_CH,MIDOUT)
  DIGIPOT(DP_TREB_CH,TREBOUT)
  '  IF LEVEL=0 THEN ''shutdown on mute for perfect muting
  '    PIN(DPSH_PIN)=0
  '  ELSE
  '    PIN(DPSH_PIN)=1
  '  ENDIF
  IF FADENEEDED>0 THEN
    'PRINT "FADING IN"
    FOR I = (LEVEL MOD 10) TO LEVEL-10 STEP 10
      DIGIPOT(DP_PRE_CH,I)
      'PRINT I
      'PAUSE 0.1
    NEXT I
  ENDIF
  DIGIPOT(DP_PRE_CH,LEVEL)
  'PRINT "DONE"
  MASTERVOLOLD=MASTERVOL
  MUTEOLD=MUTE
  'PRESETOLD=PRESET 'this won't always need changing except in MAIN for display purposes
  INLEVELOLD=INLEVEL
  BASSLEVELOLD=BASSLEVEL
  MIDLEVELOLD=MIDLEVEL
  TREBLELEVELOLD=TREBLELEVEL
  AUDIOINOLD=AUDIOIN
  LOUDNESSOLD=LOUDNESS
  'PRINT BASSOUT,MIDOUT,TREBOUT
END SUB
  
SUB RLY4(V AS INTEGER)
  IF V>0 THEN
    PIN(RLY4_PIN)=0
  ELSE
    PIN(RLY4_PIN)=1
  ENDIF
END SUB
  
SUB INITIO
  ''LED on to show power on, active low
  PIN(LED_PIN)=0
  ''all off
  PIN(RLY1_PIN)=1
  PIN(RLY2_PIN)=1
  PIN(RLY3_PIN)=1
  PIN(RLY4_PIN)=1
  'enable drivers
  SETPIN LED_PIN,DOUT
  SETPIN RLY1_PIN,DOUT
  SETPIN RLY2_PIN,DOUT
  SETPIN RLY3_PIN,DOUT
  SETPIN RLY4_PIN,DOUT
  ''DIGIPOT IO
  PIN(DP1_PIN)=1
  SETPIN DP1_PIN,DOUT
  PIN(DP2_PIN)=1
  SETPIN DP2_PIN,DOUT
  'initial bringup of RS
  PIN(DPRS_PIN)=1
  SETPIN DPRS_PIN,DOUT
  'start at max attenuation, EQ at mids
  DIGIPOT(DP_PRE_CH,0)
  DIGIPOT(DP_BASS_CH,128)
  DIGIPOT(DP_MID_CH,128)
  DIGIPOT(DP_TREB_CH,128)
  'take out of shutdown
  PIN(DPSH_PIN)=1
  SETPIN DPSH_PIN,DOUT
  'set up initial states MASTERVOLOLD, MUTEOLD, PRESETOLD, INLEVELOLD, BASSLEVELOLD, MIDLEVELOLD, TREBLELEVELOLD, AUDIOINOLD, LOUDNESSOLD
  MASTERVOLOLD=0
  MUTEOLD=1  'equivalent to a muted startup, so we need to fade in
  PRESETOLD=-1
  INLEVELOLD=0
  BASSLEVELOLD=0
  MIDLEVELOLD=0
  TREBLELEVELOLD=0
  AUDIOINOLD=4 'this is what that hardware is set to on poweroff
  LOUDNESSOLD=0
END SUB
  
SUB DIGIPOT(CC AS INTEGER, VV AS INTEGER) ''this drives both channels together
  LOCAL INTEGER P,A,V
  V=VV
  A= CC MOD 4
  IF V<0 THEN V=0
  IF V>255 THEN V=255
  V=V+A*256   'convert to one byte
  SPI OPEN 5000000,0,16 ''10MHz in nominal max, last 10 bits of data expected
  PIN(DP1_PIN)=0
  PIN(DP2_PIN)=0
  SPI WRITE 1,V
  PIN(DP1_PIN)=1
  PIN(DP2_PIN)=1
  SPI CLOSE
  '  PRINT "DIGIPOT:";CC,VV;"=";V
END SUB
  
SUB SETINPUT(N AS INTEGER)
  SELECT CASE N
    CASE 1
      PIN(RLY1_PIN)=0
      PIN(RLY2_PIN)=1
      PIN(RLY3_PIN)=0
    CASE 2
      PIN(RLY1_PIN)=1
      PIN(RLY2_PIN)=1
      PIN(RLY3_PIN)=0
    CASE 3
      PIN(RLY1_PIN)=1
      PIN(RLY2_PIN)=0
      PIN(RLY3_PIN)=1
    CASE 4
      PIN(RLY1_PIN)=1
      PIN(RLY2_PIN)=1
      PIN(RLY3_PIN)=1
  END SELECT
END SUB
  
SUB DRAWBUTTON(N AS INTEGER,MODE AS INTEGER,X AS INTEGER,Y AS INTEGER,W AS INTEGER,H AS INTEGER,S AS STRING)
  LOCAL INTEGER FNT,SC,FW
  FNT=1
  SC=1
  FONT FNT,SC
  FW=MM.FONTWIDTH
  IF MODE=0 THEN  'init
    B_COORD(N,0)=X*SX
    B_COORD(N,1)=Y*SY
    B_COORD(N,2)=W*SX
    B_COORD(N,3)=H*SY
    BUTTON_TEXT(N)=S
  ENDIF
  IF LEN(BUTTON_TEXT(N))>0 THEN SC = (B_COORD(N,2)-SX*2)\(FW*LEN(BUTTON_TEXT(N))) ELSE SC=1 'doesn't matter if""
  IF SC * MM.FONTHEIGHT > (B_COORD(N,3)-SX*2) THEN SC=(B_COORD(N,3)-SX*2)\MM.FONTHEIGHT
  IF SC < 1 THEN SC=1
  'IF B_COORD(N,2) > (FW*LEN(BUTTON_TEXT(N))*2+4) THEN SC=2 ''if room to expand widthways, do so
  IF MODE=2 THEN  ''pressed,draw reverse
    BOX B_COORD(N,0),B_COORD(N,1),B_COORD(N,2),B_COORD(N,3),2,C.B,BUTTON_COL
    TEXT B_COORD(N,0)+B_COORD(N,2)\2,B_COORD(N,1)+B_COORD(N,3)\2,BUTTON_TEXT(N),CM,FNT,SC,C.B,BUTTON_COL
  ENDIF
  IF (MODE=1) OR (MODE=0) THEN  ''pressed,draw normal
    BOX B_COORD(N,0),B_COORD(N,1),B_COORD(N,2),B_COORD(N,3),2,BUTTON_COL,C.B
    TEXT B_COORD(N,0)+B_COORD(N,2)\2,B_COORD(N,1)+B_COORD(N,3)\2,BUTTON_TEXT(N),CM,FNT,SC,BUTTON_COL,C.B
  ENDIF
END SUB
  
FUNCTION CHECKBUTTON(N0 AS INTEGER,N1 AS INTEGER) AS INTEGER
  LOCAL INTEGER X,Y,N
  CHECKBUTTON=-1  'default=no press
  X=TOUCH(X)
  Y=TOUCH(Y)
  IF X<0 THEN EXIT FUNCTION 'no press,return
  FOR N=N0 TO N1
    IF X>B_COORD(N,0) AND X<B_COORD(N,0)+B_COORD(N,2) AND Y>B_COORD(N,1) AND Y<B_COORD(N,1)+B_COORD(N,3) THEN
      CHECKBUTTON=N
    ENDIF
  NEXT N
  IF CHECKBUTTON > -1 THEN DRAWBUTTON(CHECKBUTTON,2)
END FUNCTION
  
FUNCTION ISBUTTONPRESSED(N AS INTEGER) AS INTEGER
  LOCAL INTEGER X,Y
  ISBUTTONPRESSED=0  'default=no press
  X=TOUCH(X)
  Y=TOUCH(Y)
  IF X<0 THEN EXIT FUNCTION 'no press,return
  IF X>B_COORD(N,0) AND X<B_COORD(N,0)+B_COORD(N,2) AND Y>B_COORD(N,1) AND Y<B_COORD(N,1)+B_COORD(N,3) THEN ISBUTTONPRESSED=1
END FUNCTION
  
SUB CHECKRELEASE(N AS INTEGER)
  DO WHILE CHECKBUTTON(N,N)=N
    IDLE(10)
  LOOP
  DRAWBUTTON(N,1)
  IDLE(10)
END SUB
  
SUB INITDATA  'don't call this more that once as it declares global variables
  DIM INTEGER SAVENEEDED, SAVENEEDEDOLD, LASTSAVETIME, LASTBACKLIGHT, USESLEEP
  SAVENEEDED=0
  SAVENEEDEDOLD=0
  LASTSAVETIME=TIMER
  LASTBACKLIGHT=0
  USESLEEP=0
  DIM INTEGER IRDEVICE,IRCODE,IRDATA
  IRDEVICE=0
  IRCODE=0
  IRDATA=0  'is data available?
  IR IRDEVICE,IRCODE,IR_INT
  DIM STRING SPLASHA,SPLASHB
  DIM INTEGER SPLASHTIMEOUT,SPLASHNEEDED,LEDTIMEOUT
  SPLASHNEEDED=0
  DIM FLOAT FREQ(FREQCOUNT),DB(5,FREQCOUNT) 'most declared below
  DIM FLOAT DBCURRENT(FREQCOUNT),DBOLD(FREQCOUNT)
  LOCAL INTEGER I
  FOR I = 0 TO FREQCOUNT-1
    DBOLD(I)=0
  NEXT I
  FREQ(0)=20
  FREQ(1)=50
  FREQ(2)=100
  FREQ(3)=200
  FREQ(4)=500
  FREQ(5)=1000
  FREQ(6)=2000
  FREQ(7)=5000
  FREQ(8)=10000
  FREQ(9)=20000
  
  'baseline, Level,Bass,mid,treble effect
  'V1 components/ranges
  'DB(0,0)=0:DB(1,0)=0.115234375:DB(2,0)=0.100980392156863:DB(3,0)=0:DB(4,0)=0:
  'DB(0,1)=1:DB(1,1)=0.115234375:DB(2,1)=0.109803921568627:DB(3,1)=0:DB(4,1)=0:
  'DB(0,2)=1.25:DB(1,2)=0.115234375:DB(2,2)=0.0921568627450981:DB(3,2)=0.00686274509803922:DB(4,2)=0:
  'DB(0,3)=1.25:DB(1,3)=0.115234375:DB(2,3)=0.0588235294117647:DB(3,3)=0.0225490196078431:DB(4,3)=0.00196078431372549:
  'DB(0,4)=1.5:DB(1,4)=0.1171875:DB(2,4)=0.0225490196078431:DB(3,4)=0.0637254901960784:DB(4,4)=0.00392156862745098:
  'DB(0,5)=1.5:DB(1,5)=0.1171875:DB(2,5)=0.00686274509803922:DB(3,5)=0.0725490196078431:DB(4,5)=0.00686274509803922:
  'DB(0,6)=1.5:DB(1,6)=0.1171875:DB(2,6)=0.00196078431372549:DB(3,6)=0.0549019607843137:DB(4,6)=0.0156862745098039:
  'DB(0,7)=1.5:DB(1,7)=0.1171875:DB(2,7)=0:DB(3,7)=0.0215686274509804:DB(4,7)=0.0392156862745098:
  'DB(0,8)=1.5:DB(1,8)=0.1171875:DB(2,8)=0:DB(3,8)=0.00686274509803922:DB(4,8)=0.0588235294117647:
  'DB(0,9)=1.5:DB(1,9)=0.1171875:DB(2,9)=0:DB(3,9)=0.00294117647058823:DB(4,9)=0.0715686274509804:
  
  'baseline, Level,Bass,mid,treble effect
  'V2 components/ranges
  DB(0,0)=1.249759:DB(1,0)=0.230674:DB(2,0)=0.185784:DB(3,0)=0.002616:DB(4,0)=0.000073:
  DB(0,1)=1.478031:DB(1,1)=0.231954:DB(2,1)=0.163094:DB(3,1)=0.020589:DB(4,1)=0.002576:
  DB(0,2)=1.529167:DB(1,2)=0.232090:DB(2,2)=0.115625:DB(3,2)=0.058660:DB(4,2)=0.005925:
  DB(0,3)=1.536903:DB(1,3)=0.231999:DB(2,3)=0.058707:DB(3,3)=0.106333:DB(4,3)=0.011527:
  DB(0,4)=1.565963:DB(1,4)=0.232144:DB(2,4)=0.012826:DB(3,4)=0.117221:DB(4,4)=0.022698:
  DB(0,5)=1.589504:DB(1,5)=0.232185:DB(2,5)=0.001017:DB(3,5)=0.076238:DB(4,5)=0.043125:
  DB(0,6)=1.611176:DB(1,6)=0.232189:DB(2,6)=-0.00067:DB(3,6)=0.030151:DB(4,6)=0.070952:
  DB(0,7)=1.625595:DB(1,7)=0.232226:DB(2,7)=-0.00022:DB(3,7)=0.005543:DB(4,7)=0.091744:
  DB(0,8)=1.629196:DB(1,8)=0.232206:DB(2,8)=-0.00005:DB(3,8)=0.001451:DB(4,8)=0.095862:
  DB(0,9)=1.634595:DB(1,9)=0.232230:DB(2,9)=-0.00002:DB(3,9)=0.000382:DB(4,9)=0.097033:
  
  DIM INTEGER IREQBAND,IRCHANGE
  IREQBAND=IR_BASS
  IRCHANGE=0
END SUB
  
SUB SETDBCURRENT(L AS INTEGER, B AS INTEGER, M AS INTEGER, T AS INTEGER)  'level, bass, mid and treble pot 0- centred
  'PRINT L,B,M,T
  LOCAL INTEGER I
  FOR I = 0 TO FREQCOUNT-1
    DBCURRENT(I)=DB(0,I)+DB(1,I)*(L)
    IF PIN(RLY4_PIN)>0 THEN 'if bypass off
      DBCURRENT(I)=DBCURRENT(I)+DB(2,I)*(B)+DB(3,I)*(M)+DB(4,I)*(T)
    ENDIF
    'PRINT FREQ(I);":";DBCURRENT(I)
  NEXT I
END SUB
  
SUB IDLE(T AS INTEGER)  ''wait for T milliseconds and run background tasks, eg IR, flash save
  LOCAL INTEGER TMOUT
  TMOUT=TIMER
  DO WHILE(TIMER < TMOUT+T)
    'idle actions here:
    'check if save needed
    IF (ISBUTTONPRESSED(SAVE_BUTTON)>0) AND (SAVENEEDED>0) THEN DOSAVE
    IF ((TIMER-LASTSAVETIME)>SAVE_TIMEOUT) AND (SAVENEEDED>0) THEN DOSAVE
    'check IR state
    IRACTION
    IF TIMER > LEDTIMEOUT THEN PIN(LED_PIN)=0  'LED on after timeout
    PAUSE 1
    'ENDIF
  LOOP
  IF SAVENEEDED=0 THEN LASTSAVETIME=TIMER 'keep this up to date to avoid save happening immediately on change
  IF SAVENEEDEDOLD <> SAVENEEDED THEN
    DRAWSAVEBUTTON
    SAVENEEDEDOLD=SAVENEEDED
  ENDIF
END SUB
  
SUB DOSAVE
  VAR SAVE MASTERVOL, MUTE, PRESET, INLEVEL, BASSLEVEL, MIDLEVEL, TREBLELEVEL, AUDIOIN, LOUDNESS
  VAR SAVE BL_NORMAL,BL_IDLE,BL_TIMEOUT,SAVE_TIMEOUT,PRESETS(),PRESETNAMES()
  SAVENEEDED=0
  'PRINT "SAVE DONE, LAST:";LASTSAVETIME;" NOW:";TIMER;" DELTA=";TIMER-LASTSAVETIME
END SUB
  
SUB DRAWSAVEBUTTON
  'do a little trick here to change the button colour
  IF SAVENEEDED>0 THEN
    BUTTON_COL=C.SAVENEEDED
  ELSE
    BUTTON_COL=C.SAVEDONE
  ENDIF
  DRAWBUTTON(SAVE_BUTTON,1)
  BUTTON_COL=C.BUTTON
END SUB
  
SUB TOASTBANNER(A AS STRING, B AS STRING)
  LOCAL INTEGER N
  N= LEN(A)
  IF LEN(B)>N THEN N= LEN(B)
  IF N> 18 THEN
    N=18
    A=LEFT$(A,18)
    B=LEFT$(B,18)
  ENDIF
  N=N+1
  BOXS 5,40,70,35,2,C.F,C.B
  TEXTS 40,44,A,CT,1,2,C.F,C.B
  TEXTS 40,61,B,CT,1,2,C.F,C.B
  IDLE (2000)
END SUB
  
FUNCTION GET_NUMBER_PAD(P AS STRING) AS INTEGER
  GET_NUMBER_PAD=-1 'fail/cancel
  LOCAL STRING ENTRY
  LOCAL INTEGER C
  ENTRY=""
  CLS(C.B)
  DrawButton 0,0,  16,  65, 15, 14,  "0"
  DrawButton 1,0,  32,  65, 15, 14,  "1"
  DrawButton 2,0,  48,  65, 15, 14,  "2"
  DrawButton 3,0,  64,  65, 15, 14,  "3"
  DrawButton 4,0,  32,  50, 15, 14,  "4"
  DrawButton 5,0,  48,  50, 15, 14,  "5"
  DrawButton 6,0,  64,  50, 15, 14,  "6"
  DrawButton 7,0,  32,  35, 15, 14,  "7"
  DrawButton 8,0,  48,  35, 15, 14,  "8"
  DrawButton 9,0,  64,  35, 15, 14,  "9"
  DrawButton 10,0,  0,  65, 15, 14,  "<-"
  DrawButton 11,0,  0,  50, 15, 14,  "OK"
  DrawButton 12,0,  0,  35, 15, 14,  "Cancel"
  TEXTS 0,0,P,LT,1,2,C.F,C.B
  DO
    C=CHECKBUTTON(0, 12)
    IF C >= 0 THEN
      CHECKRELEASE(C)
      if C = 0 THEN ENTRY=ENTRY+"0"
      if C = 1 THEN ENTRY=ENTRY+"1"
      if C = 2 THEN ENTRY=ENTRY+"2"
      if C = 3 THEN ENTRY=ENTRY+"3"
      if C = 4 THEN ENTRY=ENTRY+"4"
      if C = 5 THEN ENTRY=ENTRY+"5"
      if C = 6 THEN ENTRY=ENTRY+"6"
      if C = 7 THEN ENTRY=ENTRY+"7"
      if C = 8 THEN ENTRY=ENTRY+"8"
      if C = 9 THEN ENTRY=ENTRY+"9"
      if (C = 10) AND (LEN(ENTRY)>0) THEN ENTRY=left$(ENTRY,LEN(ENTRY)-1)
      IF LEN(ENTRY)>9 THEN ENTRY=LEFT$(ENTRY,9)     'truncate
      if C = 12 THEN GET_NUMBER_PAD=-1: EXIT FUNCTION 'cancel
      if C = 11 THEN 'OK
        GET_NUMBER_PAD=VAL(ENTRY)
        EXIT FUNCTION
      ENDIF
    ENDIF
    IF (TIMER\300) MOD 2 >0 THEN
      TEXTS 0,15,RIGHT$("               "+ENTRY+"_",10),LT,1,4,C.F,C.B
    ELSE
      TEXTS 0,15,RIGHT$("               "+ENTRY+" ",10),LT,1,4,C.F,C.B
    ENDIF
    IDLE(10)
  LOOP
END FUNCTION
  
FUNCTION GET_KEY_PAD(P AS STRING) AS STRING
  GET_KEY_PAD=""  'use this to store entry
  LOCAL INTEGER I,C
  LOCAL STRING K
  CLS(C.B)
  LOCAL STRING KEY="1234567890QWERTYUIOPASDFGHJKLeZXCVBNM bc" 'e,b,c=enter, backspace, cancel
  FOR I = 0 TO 39
    K=MID$(KEY,I+1,1)
    IF K = "e" THEN K="ENT"
    IF K = "b" THEN K="<-"
    IF K = "c" THEN K="CAN"
    DRAWBUTTON(I,0,(I MOD 10)*8,(I \ 10)*11+35, 8,11,K)
  NEXT I
  TEXTS 0,0,P,LT,1,2,C.F,C.B
  DO
    C=CHECKBUTTON(0,39)
    IF C >= 0 THEN
      CHECKRELEASE(C)
      K=MID$(KEY,C+1,1)
      IF K = "e" THEN EXIT FUNCTION
      IF K = "c" THEN GET_KEY_PAD="": EXIT FUNCTION
      IF K = "b" THEN
        IF LEN(GET_KEY_PAD)>0 THEN GET_KEY_PAD=LEFT$(GET_KEY_PAD,LEN(GET_KEY_PAD)-1)
      ELSE
        IF LEN(GET_KEY_PAD)<8 THEN GET_KEY_PAD = GET_KEY_PAD + K
      ENDIF
    ENDIF
    IF (TIMER\300) MOD 2 >0 THEN
      TEXTS 0,15,LEFT$(GET_KEY_PAD+"_               ",10),LT,1,4,C.F,C.B
    ELSE
      TEXTS 0,15,LEFT$(GET_KEY_PAD+"                ",10),LT,1,4,C.F,C.B
    ENDIF
    IDLE(10)
  LOOP
END FUNCTION
  
FUNCTION CONFIRM_CHECK(A AS STRING, B AS STRING)
  CONFIRM_CHECK=0'no
  LOCAL INTEGER N
  N= LEN(A)
  IF LEN(B)>N THEN N= LEN(B)
  IF N> 18 THEN
    N=18
    A=LEFT$(A,18)
    B=LEFT$(B,18)
  ENDIF
  IF N < 10 THEN N = 10
  N=N+1
  BOXS 5,23,70,50,2,C.F,C.B
  TEXTS 40,27,A,CT,1,2,C.F,C.B
  TEXTS 40,44,B,CT,1,2,C.F,C.B
  DRAWBUTTON(0,0,43,60,15,10,"NO")
  DRAWBUTTON(1,0,22,60,15,10,"YES")
  DO
    C=CHECKBUTTON(0,1)
    IF C >= 0 THEN
      CHECKRELEASE(C)
      CONFIRM_CHECK=C
      EXIT FUNCTION
    ENDIF
  LOOP
END SUB
  
SUB IR_INT
  IRDATA=1  ''handle this out of interrupt context
END SUB
  
  'these functions can be called by user, eg from IR commands or other inputs
  'LOADPRESET(0-5)
  'TOGGLEMUTE
  'CHANGEVOL(n)
  'DOSAVE
  
SUB IRACTION
  LOCAL INTEGER DEVICE,CODE
  IF IRDATA>0 THEN
    DEVICE=IRDEVICE
    CODE=IRCODE
    IRDATA=0  ''ready to see next
    'PRINT DEVICE,CODE  'use this to detect other codes
    IF DEVICE=255 THEN 'Jaycar XC3718
      IF CODE=224 THEN CHANGEVOL(-1):LASTBACKLIGHT=TIMER:SETSPLASH(" VOLUME ",STR$(MASTERVOL,3))
      IF CODE=168 THEN CHANGEVOL(1):LASTBACKLIGHT=TIMER:SETSPLASH(" VOLUME ",STR$(MASTERVOL,3))
      IF CODE=194 THEN TOGGLEMUTE:LASTBACKLIGHT=TIMER:IF MUTE=1 THEN SETSPLASH("  MUTE  "," ON") ELSE SETSPLASH("  MUTE  ","OFF")
      IF CODE= 48 THEN LOADPRESET(0):LASTBACKLIGHT=TIMER:SETSPLASH(PRESETNAMES(0)," OK"):IRCHANGE=1
      IF CODE= 24 THEN LOADPRESET(1):LASTBACKLIGHT=TIMER:SETSPLASH(PRESETNAMES(1)," OK"):IRCHANGE=1
      IF CODE=122 THEN LOADPRESET(2):LASTBACKLIGHT=TIMER:SETSPLASH(PRESETNAMES(2)," OK"):IRCHANGE=1
      IF CODE= 16 THEN LOADPRESET(3):LASTBACKLIGHT=TIMER:SETSPLASH(PRESETNAMES(3)," OK"):IRCHANGE=1
      IF CODE= 56 THEN LOADPRESET(4):LASTBACKLIGHT=TIMER:SETSPLASH(PRESETNAMES(4)," OK"):IRCHANGE=1
      IF CODE= 90 THEN LOADPRESET(5):LASTBACKLIGHT=TIMER:SETSPLASH(PRESETNAMES(5)," OK"):IRCHANGE=1
      IF CODE= 66 THEN LEDFLASH:IREQBAND = IR_BASS:IRCHANGE=1'7
      IF CODE= 74 THEN LEDFLASH:IREQBAND = IR_MID :IRCHANGE=1'8
      IF CODE= 82 THEN LEDFLASH:IREQBAND = IR_TREB:IRCHANGE=1'9
      IF CODE=104 THEN LEDFLASH:IREQBAND = IR_LOUD:IRCHANGE=1'0
      IF CODE=226 THEN LEDFLASH:DO_CHUP:IRCHANGE=1 'CHUP
      IF CODE=162 THEN LEDFLASH:DO_CHDN:IRCHANGE=1 'CHDN
    ENDIF
    IF DEVICE=255 THEN 'Altronics A1012 with Aux set to preset 171
      'also works with Altronics A1012A with AUX set to 0766
      IF CODE= 43 THEN CHANGEVOL(-1):LASTBACKLIGHT=TIMER:SETSPLASH(" VOLUME ",STR$(MASTERVOL,3))
      IF CODE= 19 THEN CHANGEVOL(1):LASTBACKLIGHT=TIMER:SETSPLASH(" VOLUME ",STR$(MASTERVOL,3))
      IF CODE=105 THEN TOGGLEMUTE:LASTBACKLIGHT=TIMER:IF MUTE=1 THEN SETSPLASH("  MUTE  "," ON") ELSE SETSPLASH("  MUTE  ","OFF")
      IF CODE=129 THEN LOADPRESET(0):LASTBACKLIGHT=TIMER:SETSPLASH(PRESETNAMES(0)," OK"):IRCHANGE=1
      IF CODE=193 THEN LOADPRESET(1):LASTBACKLIGHT=TIMER:SETSPLASH(PRESETNAMES(1)," OK"):IRCHANGE=1
      IF CODE=131 THEN LOADPRESET(2):LASTBACKLIGHT=TIMER:SETSPLASH(PRESETNAMES(2)," OK"):IRCHANGE=1
      IF CODE= 65 THEN LOADPRESET(3):LASTBACKLIGHT=TIMER:SETSPLASH(PRESETNAMES(3)," OK"):IRCHANGE=1
      IF CODE=  1 THEN LOADPRESET(4):LASTBACKLIGHT=TIMER:SETSPLASH(PRESETNAMES(4)," OK"):IRCHANGE=1
      IF CODE=  3 THEN LOADPRESET(5):LASTBACKLIGHT=TIMER:SETSPLASH(PRESETNAMES(5)," OK"):IRCHANGE=1
      IF CODE=177 THEN LEDFLASH:IREQBAND = IR_BASS:IRCHANGE=1'7
      IF CODE=241 THEN LEDFLASH:IREQBAND = IR_MID :IRCHANGE=1'8
      IF CODE=179 THEN LEDFLASH:IREQBAND = IR_TREB:IRCHANGE=1'9
      IF CODE= 49 THEN LEDFLASH:IREQBAND = IR_LOUD:IRCHANGE=1'0
      IF CODE=147 THEN LEDFLASH:DO_CHUP:IRCHANGE=1' CHUP
      IF CODE=145 THEN LEDFLASH:DO_CHDN:IRCHANGE=1' CHDN
    ENDIF
  ENDIF
END SUB
  
SUB DO_CHUP
  SAVENEEDED=1  'pretty much any action needs a save
  IF IREQBAND = IR_BASS THEN
    BASSLEVEL=BASSLEVEL+1
    IF BASSLEVEL>127 THEN BASSLEVEL=127
  ENDIF
  IF IREQBAND = IR_MID  THEN
    MIDLEVEL=MIDLEVEL+1
    IF MIDLEVEL>127 THEN MIDLEVEL=127
  ENDIF
  IF IREQBAND = IR_TREB THEN
    TREBLELEVEL=TREBLELEVEL+1
    IF TREBLELEVEL>127 THEN TREBLELEVEL=127
  ENDIF
  IF IREQBAND = IR_LOUD THEN
    LOUDNESS=LOUDNESS+1
    IF LOUDNESS>4 THEN LOUDNESS=4
  ENDIF
END SUB
  
SUB DO_CHDN
  SAVENEEDED=1  'pretty much any action needs a save
  IF IREQBAND = IR_BASS THEN
    BASSLEVEL=BASSLEVEL-1
    IF BASSLEVEL<-127 THEN BASSLEVEL=-127
  ENDIF
  IF IREQBAND = IR_MID  THEN
    MIDLEVEL=MIDLEVEL-1
    IF MIDLEVEL<-127 THEN MIDLEVEL=-127
  ENDIF
  IF IREQBAND = IR_TREB THEN
    TREBLELEVEL=TREBLELEVEL-1
    IF TREBLELEVEL<-127 THEN TREBLELEVEL=-127
  ENDIF
  IF IREQBAND = IR_LOUD THEN
    LOUDNESS=LOUDNESS-1
    IF LOUDNESS<0 THEN LOUDNESS=0
  ENDIF
END SUB
  
SUB LEDFLASH
  LEDTIMEOUT=TIMER+LEDDELAY
  PIN(LED_PIN)=1  'LED off, turned off by timeout in IDLE
END SUB
  
SUB SETSPLASH(A AS STRING, B AS STRING) 'sets flags, loads strings
  SPLASHNEEDED=1
  SPLASHTIMEOUT=TIMER+SPLASHDELAY
  SPLASHA=A
  SPLASHB=B
  LEDFLASH  'also set LED timeout
END SUB
  
SUB DOSPLASH(A AS STRING, B AS STRING, N as INTEGER)  '0 means initial (with box), 1 means repeat
  A=LEFT$(A+"        ",8)
  B=LEFT$(B,3)
  IF N = 0 THEN BOXS 5,13,70,61,2,C.F,C.B
  TEXTS 40,14,A,CT,1,4,C.F,C.B
  TEXTS 40,31,B,CT,1,9,C.F,C.B
  SETBACKLIGHT(BL_NORMAL) 'wakeup
END SUB
  
SUB TEXTS(X AS INTEGER, Y AS INTEGER, S AS STRING, A AS INTEGER, FNT AS INTEGER, SC AS INTEGER, CF AS INTEGER, CB AS INTEGER)
  LOCAL INTEGER SCC
  SCC=(SC*SX)\4
  IF SCC<1 THEN SCC=1
  SELECT CASE A
    CASE CT
      TEXT X*SX,Y*SY,S,CT,FNT,SCC,CF,CB
    CASE RT
      TEXT X*SX,Y*SY,S,RT,FNT,SCC,CF,CB
    CASE LM
      TEXT X*SX,Y*SY,S,LM,FNT,SCC,CF,CB
    CASE CM
      TEXT X*SX,Y*SY,S,CM,FNT,SCC,CF,CB
    CASE RM
      TEXT X*SX,Y*SY,S,RM,FNT,SCC,CF,CB
    CASE LB
      TEXT X*SX,Y*SY,S,LB,FNT,SCC,CF,CB
    CASE CB
      TEXT X*SX,Y*SY,S,CB,FNT,SCC,CF,CB
    CASE RB
      TEXT X*SX,Y*SY,S,RB,FNT,SCC,CF,CB
    CASE ELSE 'default is LT
      TEXT X*SX,Y*SY,S,LT,FNT,SCC,CF,CB
  END SELECT
END SUB
  
  'these have float to allow smoother scaling
SUB BOXS(X AS FLOAT, Y AS FLOAT,W AS FLOAT, H AS FLOAT, L AS INTEGER, CF AS INTEGER, CB AS INTEGER)
  BOX X*SX,Y*SY,W*SX,H*SY,L,CF,CB
END SUB
  
SUB LINES(X1 AS FLOAT, Y1 AS FLOAT, X2 AS FLOAT, Y2 AS FLOAT, L AS INTEGER, CF AS INTEGER)
  LINE X1*SX,Y1*SY,X2*SX,Y2*SY,L,CF
END SUB
  
DefineFont #10
  01202F78 00000000 00000000 00000000 00000000 F003FC01 07F801FE 017E00F0
  07007EF0 FEF003FF FC1FF803 F081FF03 FF1F007E 03FCF087 0FFE7FF8 7CF8C3FF
  C7FF3F00 F003FCF1 FF1FFFFF 007CF8E3 F1C79F3F FCF007FC E38F1F7F 7F00FCF8
  FCE1C71F 7FFCF107 F8E38F3F 1F7F00FC 07FCE18F 3F7FFCF1 FCFCE78F 0F007F00
  F107F8E3 8F3F7EFC 00F8FDC7 E30FF07F F8E10FF8 C71F3F00 7F00F8FD F8E30FFC
  00F8E30F FFC71F7F FE3F00F8 0FF8C31F 7F00F8E3 F8FFCF1F 1FFF0F00 E30FF0C7
  1F7F00F8 00F8FFCF C71F7F00 F0C30FF0 8F3F7FFC 0000F0DF F0C71F7F FCF1C71F
  CF8F3FFE 7FFC01F0 1FF0871F FEFCF1C7 F0CF9F3F 3F7FFC01 C71FE087 3FFEFCF1
  01F0CF9F 8F3FFEFC F3871FF0 1F7FFFF8 FF01F08F FF8F3FFE F8FF87BF 8F1FFFFF
  F8FF00E0 BFFF0F3F 7FE0FF83 E0873FFE 7FE07F00 813FFF0F F83FC0FF 00E0873F
  1F7FC03F FF803FFF 3FE01F80 0000E007 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 FF000000 0F3FFCC0 00E0FFC3 00000000 E0FF0300 C31F7FFC
  0000F8FF 00000000 FCF9FF07 FFC31F7F 000000FC 0F000000 7FFCF9E3 FCFBC71F
  00000000 E30F0000 1F7EFCF1 00F8F187 00000000 F1C30F00 871F7EF8 0000F8F3
  00000000 F8F3C71F F3873FFE 000000F8 1F000000 FEF803C0 F8E3873F 00000000
  C01F0000 3FFCFF03 00F0E30F 00000000 03801F00 0F3FFCFF 0000F0FF 00000000
  FF03801F FF0F7FFC 000000E0 3F000000 FCF1C787 80FF0F7F 00000000 8F3F0000
  7EF8F1C7 0000FE1F 00000000 C70F3F00 1F7EF8E1 000000C0 00000000 E1C70F3F
  C01F7EF8 00000000 3F000000 F8E3C71F 00801FFE 00000000 FF3F0000 FCF0E38F
  0000801F 00000000 0FFF3F00 3FFCF0C3 00000080 00000000 C30FFC0F 803FFCF0
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000
End DefineFont